<?php
class MpesaTimRepository{
  
     public function getCurl($url, $headers=null, $method=null, $data=null){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        // curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        if($method){
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }
        $curl_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $json_response = null;
        if ($status == 200 || $status == 201) {
            $json_response = json_decode($curl_response); 
            return $json_response;
        } else {
            print_r($curl_response);
            throw new Exception($curl_response);
        }
     }

     public function getAccesToken($type = null){
         if($type == "b2c"){
               //B2C live
              $client_id = "VPk7J9eppnVBBMwsGPQzs5W0wEpESW3r";
              $secret_id = "96jorJxWSpBu4eTU";
         }else{
             //c2v live
              $client_id = "GY2gHJYoGe8S4DOPgE2AaLImn7pAAcPp";
              $secret_id = "e17wVWQefpJ7epk2";
         }
        $headers = [
            'Accept: application/json',
            'Authorization: Basic '.base64_encode($client_id.':'.$secret_id),
        ];
        // $url = 'https://sandbox.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

        $url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';
        
        $res = $this->getCurl($url, $headers);
        $access_token = $res->access_token;
        return $access_token;
     }

     public function lipaNaMpesa($amount, $phone, $acc_no){
         $phone = $this->formatPhone($phone);
         $shortcode = '4060535';
         $partyB = '4060535';
        //  $shortcode = '174379';
        //  $passkey = 'bfb279f9aa9bdbcf158e97dd71a467cd2e0c893059b10f78e6b72ada1ed2c919';
         $phone=preg_replace('/(\W*)/', '', $phone);
         $passkey = '9da83cade7b20bb6735f114f036b70ce14d7848f1fe6e2dd8a799ca760ecd431';

        //  $timestamp = date('YmdGis');;
         $timestamp = '20190116143600';
         $passwd = base64_encode($shortcode.$passkey.$timestamp);
         $call_back_url = "https://naismerchants.com/checkout/stk_callback.php?acc_no=$acc_no";
         $desc = "Top up to ".$acc_no;
         $method = "POST";

        // $url = 'https://sandbox.safaricom.co.ke/mpesa/stkpush/v1/processrequest';
        $url = 'https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest';
        $headers = ['Content-Type:application/json','Authorization:Bearer '.$this->getAccesToken()];
        
        $data = [
            'BusinessShortCode' => $shortcode,
            'Password' => $passwd,
            'Timestamp' => $timestamp,
            'TransactionType' => 'CustomerPayBillOnline',
            'Amount' => $amount,
            'PartyA' => $phone,
            'PartyB' => $partyB,
            'PhoneNumber' => $phone,
            'CallBackURL' => $call_back_url,
            'AccountReference' => $acc_no,
            'TransactionDesc' => $desc
            ];
        $data = json_encode($data);
        $res = $this->getCurl($url, $headers, $method, $data);
     }

     public function registerUrl(){
        $shortCode = '';
         $headers = ['Content-Type:application/json', 'Authorization:Bearer '.$this->getAccesToken()];

        $url = 'https://api.safaricom.co.ke/mpesa/c2b/v1/registerurl';
        $shortCode = '4060535';
        $method = 'POST';
        $confirmationUrl = 'https://naismerchants.com/checkout/c2b_confirmation_url.php';
        $validationUrl = 'https://naismerchants.com/checkout/c2b_validation_url.php';

        $data = ['ShortCode' => $shortCode,
            'ResponseType' => 'Completed',
            'ConfirmationURL' => $confirmationUrl,
            'ValidationURL' => $validationUrl
        ];
        
        $data = json_encode($data);
        $res = $this->getCurl($url, $headers, $method, $data);
         
     }

     public function b2c($amount, $phone){
        $url = 'https://api.safaricom.co.ke/mpesa/b2c/v1/paymentrequest';
        $headers = ['Content-Type:application/json', 'Authorization:Bearer '.$this->getAccesToken("b2c")];
        $method = "POST";
        $phone=preg_replace('/(\W*)/', '', $phone);
        
        $InitiatorName ='B2CACCOUNTANT';
        $SecurityCredential ='a/lUAVHPLpL4ZK0C5qA743brcYjhcaewwiQgGKPR1MPBOYBosTaX8GC22BD+BQGHtCuNN0T2VzKa451CG9w9hD4TrBu0kYhwTuMd2+P7yLcRVpY/9hGw87NAlJe9klkD1i2bwcTC8krnxeP+FhQPcv6xA++T3N8K3VTNF5FIzt7T1q5h5jNGUXUd9JRlfg9Yd0I2YjqQmnpPZmNjD2Co8p7qPk1OxKe/wJh4dkHNNXRnL7Gqlx+3deI91BCLuBuxPqUduhsvonTuPYdOOenQbqrm7m61LiaFwbdgTXrPBQBjeE7BvZq0pb9KTOda+pmFInqJhzdv07pz7PRshGh+ew==';
        $CommandID = 'BusinessPayment';
        $Amount = $amount;
        $PartyA = '3131537';
        $PartyB = $phone;
        $Remarks = 'Withdrawal to Mpesa';
        $callback_url = "https://naismerchants.com/checkout/mpesa_callback.php";
        $QueueTimeOutURL = $callback_url;
        $ResultURL = $callback_url;
        $Occasion = 'PAYMENT FROM NAISMERCHANTS';
        
        $data = array(
        'InitiatorName' => $InitiatorName,
        'SecurityCredential' => $SecurityCredential,
        'CommandID' => $CommandID ,
        'Amount' => $Amount,
        'PartyA' => $PartyA ,
        'PartyB' => $PartyB,
        'Remarks' => $Remarks,
        'QueueTimeOutURL' => $QueueTimeOutURL,
        'ResultURL' => $ResultURL,
        'Occasion' => $Occasion
         );
         $data = json_encode($data);

        $res = $this->getCurl($url, $headers, $method, $data);
     }
     
     public function c2b($account, $phone, $amount){
         $url = "https://api.safaricom.co.ke/mpesa/c2b/v1/simulate";
         $shortcode = '4060535';
         $phone = $this->formatPhone($phone);
         $headers = ['Content-Type:application/json', 'Authorization:Bearer '.$this->getAccesToken("b2c")];
         $method = "POST";
         
         $data = [
            //Fill in the request parameters with valid values
           'ShortCode' => $shortcode,
           'CommandID' => 'CustomerPayBillOnline',
           'Amount' => $amount,
           'Msisdn' => $phone,
           'BillRefNumber' => $account
        ];
        $data = json_encode($data);
        
        $res = $this->getCurl($url, $headers, $method, $data);
     }
     
     public function formatPhone($phone){
        $len = strlen($phone);
        if($len==10){
            $phone = "repl".$phone;
            $phone = str_replace('repl07','2547',$phone);
        }
        if($len==12){
            $phone = ''.$phone;
        }

        return $phone;
    }
     
}

//$res = new MpesaTimRepository;
//var_dump($res->registerMpesaUrls());
//echo $res->lipaNaMpesa();
